﻿using System;
using System.Globalization;
using System.Xml.Linq;

namespace Azyobuzi.Twikoto2.Models.Twitter
{
    public class Status
    {
        public Status() { }

        public Status(XElement xml)
        {
            this.CreatedAt = DateTime.ParseExact(
                xml.Element("created_at").Value,
                "ddd MMM dd HH:mm:ss %zzzz yyyy",
                CultureInfo.InvariantCulture,
                DateTimeStyles.AssumeUniversal);
            this.Id = xml.Element("id").Value;
            this.InReplyToStatusId = xml.Element("in_reply_to_status_id").Value;
            this.Text = xml.Element("text").Value;
            this.User = new User(xml.Element("user"));
        }

        public DateTime CreatedAt { get; set; }
        public string Id { get; set; }
        public string InReplyToStatusId { get; set; }
        public string Text { get; set; }
        public User User { get; set; }
    }
}
